<?php
// $Id;$

/**
 *
 */
function _trackback_send($nid) {
  if (!is_numeric($nid))
    return FALSE;
  
  if (!trackback_node_enabled($nid))
    return FALSE;

  drupal_set_message(__function__ .'() NID='. var_export($nid, TRUE));
  $node = node_load($nid);

  $urls = array();

  if (variable_get('trackback_auto_detection', 'auto') == 'user' && !empty($node->trackback_urls)) {
    // Use user provided URLs
    foreach (explode("\n", $node->trackback_urls) as $url) {
      if ($url = trim($url)) {
        $urls[] = $url;
      }
    }
  }
  else {
    // Use auto-discovery feature
    $urls = _trackback_extract_urls($node);
  }
  $retry = array();
  /*
  if (isset($node->trackback_urls_to_retry)) {
    $retry = array_diff($node->trackback_urls_to_retry, array(0));
  }
  */  
  
  $already_sent = trackback_get_sent($node, 'successful');
  $urls = array_diff($urls, $already_sent);
  
  // drupal_set_message(__function__ .'() FINAL='. var_export($urls, TRUE));
  
  foreach($urls as $url) {
    $pos = strpos($url, '#');
    if ($pos !== FALSE)
      $url = substr($url, 0, $pos);
    
    drupal_set_message(__function__ .'() Sending to ='. var_export($url, TRUE));
    
    if (valid_url($url, TRUE)) {
      if (_trackback_pingback_send($node->nid, $url, TRUE)) {
        drupal_set_message(t('Pingback successfully sent to %url', array('%url' => $url)));
      }
    }
  }
  // _trackback_ping($node, $urls, $retry);
}

/**
 *
 */
function _trackback_extract_urls($node) {
  $return = array();

  // First, grab anything that looks like a url from the body of the node.
  $node = _trackback_build_content(drupal_clone($node));
  $content = drupal_render($node->content);
  $pattern = '((?:http|https)://[a-z0-9;/?:@&=+#$,_.!~*()%-]+)';

  if (variable_get('trackback_auto_detection', 'auto') == 'auto-links') {
    $content = strip_tags($content, '<a>'); // remove comment.
    $pattern = '<a\s+[^>]*href\s*=\s*(?:"|\')'. $pattern;
  }

  if (preg_match_all('`'. $pattern .'`i', $content, $parsed_urls)) {
    $return = array_unique($parsed_urls[1]);
    // drupal_set_message(__function__ .'()'. var_export($return, TRUE));
  }
  return $return;
}


/**
 * Discover if given TARGET is a trackback source or not
 */
function _trackback_trackback_discover($target) {
  $return = '';
  
  // Do something here..
  
  return $return;
}



/**
 * Discover a pingback server with pingback autodiscovery schemes.
 * @param $target the absolute URL to search for its server. This should have passed check_url() first.
 * @return the PingbackServer to send request
 */
function _trackback_pingback_discover($target) {
  // drupal_set_message(__function__);
  $server = '';
  //#1: send a HEAD to check for X-Pingback header
  $r = drupal_http_request($target, array(), 'HEAD');
  if (empty($r->error)) {
    if (is_array($r->headers) && isset($r->headers['X-Pingback'])) {
      $server = $r->headers['X-Pingback'];
    }
    else {
      //#2: search for <link rel="pingback" href="(server)" /> tags
      $get = drupal_http_request($target);
      if (empty($get->error)) {
        //this regexp is the one provided in the spec
        if (preg_match('#<link rel="pingback" href="([^"]+)" ?/?>#', $get->data, $matches)) {
          $server = $matches[1];
        }
      }
    }
  }
  if (!empty($server)) {
    // Replacements of tokens as described in http://www.hixie.ch/specs/pingback/pingback
    return check_url($server);
  }
  return '';
}

/**
 * Send pingbacks. Does nothing if the target does not have a pingback server.
 * @param $nid the source node ID.
 * @param $target the target absolute URL.
 * @param $source_is_absolute if this value is set to TRUE, $nid is interpreted as an absolute URL (which may originate not from the host site).
 * @return TRUE on success, FALSE otherwise.
 */
function _trackback_pingback_send($nid, $target) {
  $source = url("node/$nid", array('absolute' => TRUE)); 
  
  //server autodiscovery
  $server = _trackback_pingback_discover($target);
  drupal_set_message(__function__ .'() NID='. $nid . '..TARGET='.$target. ' SERVER='.$server);
  // return TRUE;

  if (!empty($server)) {
    if (xmlrpc($server, 'pingback.ping', $source, $target)) {
      trackback_sent($nid, $target, TRUE, 'Pingback');
      watchdog('trackback', 'Pingback: Pingback to %target from %source succeeded.', array('%source' => $source, '%target' => $target));
      return TRUE;
    }
    else {
      watchdog('trackback', 'Pingback: Pingback to %target from %source failed. Error @errno: @description', array('%source' => $source, '%target' => $target, '@errno' => xmlrpc_errno(), '@description' => xmlrpc_error_msg()), WATCHDOG_WARNING);
      return FALSE;
    }
  }
  // watchdog('pingback', 'Server not found', array(), WATCHDOG_WARNING);
  return FALSE;
}
